%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% mathabx.dcl. Version: May 18, 2005.
% Author: Anthony PHAN.
% matches the ``mathabx'' family.
% names almost fit newmath.sty (Matthias Clasen, Ulrik Vieth)
% not necessarily designs...
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\catcode`\@=11
%\mathabx@undefine{\models} ????
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% to be defined
%\DeclareMathSymbol{\bigtriangleup}{2}{matha}{"}
%\DeclareMathSymbol{\bigtriangledown}{2}{matha}{"}
%\DeclareMathSymbol{\square}{0}{matha}{"}
%
% SPECIAL CHARACTERS
%
\mathabx@verbose{\paragraph{Specials characters (matha/mathb)}
The two next symbols are zero-width symbols intended to negate
common relations (with width equal to $\rm14\,mu$) by overlapping
them from the left to the right. The first symbol is defined in
{\it matha}, the second one in {\it mathb}.}%
%
\mathabx@matha
\DeclareMathSymbol{\notsign}       {3}{matha}{"7F}
\end@mathabx
\mathabx@mathb
\DeclareMathSymbol{\varnotsign}    {3}{mathb}{"7F}
\end@mathabx
%
% the \not construction
%
\long\def\@gobble#1{}%
%
\def\not#1{%
	\let\@@not=\not \let\@@n=\n \let\not=\relax \let\n=\relax
	\expandafter
	\ifx\csname not\expandafter\@gobble\string#1\endcsname\relax%
	\expandafter
	\ifx\csname n\expandafter\@gobble\string#1\endcsname\relax%
	\notsign#1%
	\else
	\csname n\expandafter\@gobble\string#1\endcsname\fi
	\else\csname not\expandafter\@gobble\string#1\endcsname\fi
	\let\not=\@@not \let\n=\@@n}%
%
\ifx\mathabx@mathb\mathabx@skip
	\let\varnot=\not
	\let\changenotsign=\relax
\else
	\def\varnot#1{%
		\let\@@not=\varnot\let\varnot=\relax
		\expandafter
		\ifx
		\csname varnot\expandafter\@gobble\string#1\endcsname
		\relax%
		\varnotsign#1%
		\else
		\csname varnot\expandafter\@gobble\string#1\endcsname
		\fi
		\let\varnot=\@@not}%%
	\def\changenotsign{%
		\let\@@not=\notsign
		\let\notsign=\varnotsign
		\let\varnotsign=\@@not}%%
\fi
%
\mathabx@verbose{\noindent The control sequence {\tt\string\not} is
defined anew.  Executing {\tt\string\not\string\xxx}, it tests if
{\tt\string\notxxx} is a known control sequence and if the answer is
true it applies {\tt\string\notxxx}; if the answer is false, it tests
if {\tt\string\nxxx} is defined and if the answer is true it applies
{\tt\string\nxxx}; if both are false one gets
{\tt\string\notsign\string\xxx}. There is also the control sequence
{\tt\string\varnot} whose mecanism is close to the one of
{\tt\string\not} except that tests only {\tt\string\varnotxxx} and
uses at last {\tt\string\varnotsign}. It is also possible to switch
between {\tt\string\notsign} and {\tt\string\varnotsign} with the
control sequence {\tt\string\changenotsign} (local effect).  With
\LaTeX, one  can load only one of the series {\it matha}\/ or
{\it mathb}. The definitions of the former control sequences are also set
with respect to such a choice. ({\it Look}\/ later on for examples.)

The following symbol ({\it matha}\/) is simply the centered dot with
which various centered dots ($\cdots$ {\tt\string\cdots}) are
constructed in plain\TeX\ or\ \LaTeX. It may look like an oddity in
{\it mathabx}\/ series, bot the corresponding glyph appears next as
the usual binary operator {\tt\string\cdot}.}%
%
\mathabx@matha
\DeclareMathSymbol{\cdotp}         {6}{matha}{"04}% oddity
\end@mathabx
%
% USUAL BINARY OPERATORS
%
\mathabx@matha
\mathabx@verbose{\paragraph{Usual binary operators (matha)}
Here we have some quite common binary operators (except
{\tt\string\asterisk} and {\tt\string\coasterisk} which are ordinary
symbols). The prefix ``co'' before ``asterisk'' or such always means
that the asterisk is rotated by 30 degrees. Such asterisks, the six
branched star {\tt\string\varstar} and the
symbols {\tt\string\smallsum} and {\tt\string\smallprod} may not be
found elsewhere. Should they disappear? ({\it See}\/ also the next
paragraph.)}%
%
\DeclareMathSymbol{+}              {2}{matha}{"00}
\DeclareMathSymbol{-}              {2}{matha}{"01}
\DeclareMathSymbol{\times}         {2}{matha}{"02}
\DeclareMathSymbol{\div}           {2}{matha}{"03}
\DeclareMathSymbol{\cdot}          {2}{matha}{"04}
\DeclareMathSymbol{\circ}          {2}{matha}{"05}
\DeclareMathSymbol{*}              {2}{matha}{"06}
\DeclareMathSymbol{\ast}           {2}{matha}{"06}
\DeclareMathSymbol{\asterisk}      {0}{matha}{"06}
\DeclareMathSymbol{\coast}         {2}{matha}{"07}
\DeclareMathSymbol{\coasterisk}    {0}{matha}{"07}
\DeclareMathSymbol{\pm}            {2}{matha}{"08}
\DeclareMathSymbol{\mp}            {2}{matha}{"09}
\DeclareMathSymbol{\ltimes}        {2}{matha}{"0A}
\DeclareMathSymbol{\rtimes}        {2}{matha}{"0B}
\DeclareMathSymbol{\diamond}       {2}{matha}{"0C}
\DeclareMathSymbol{\bullet}        {2}{matha}{"0D}
\DeclareMathSymbol{\star}          {2}{matha}{"0E}
\DeclareMathSymbol{\varstar}       {2}{matha}{"0F}
\DeclareMathSymbol{\smallsum}      {2}{matha}{"3C}
\DeclareMathSymbol{\smallprod}     {2}{matha}{"3D}
\DeclareMathSymbol{\amalg}         {2}{matha}{"3E}
\mathabx@aliases\amalg\smallcoprod
\end@mathabx
%
% UNUSUAL BINARY OPERATORS
%
\mathabx@mathb
\mathabx@verbose{\paragraph{Unusual binary operators (mathb)} Here we
have some quite to very uncommon binary operators. Some of them may
seem to be pure oddities ({\tt\string\dottimes}, {\tt\string\udot},
{\tt\string\Asterisk}, {\tt\string\bigast} [which is an operator],
{\tt\string\coAsterisk}, {\tt\string\bigcoast} [which is an operator],
{\tt\string\convolution} and {\tt\string\bigvarstar}).}%
%
\DeclareMathSymbol{\dotplus}       {2}{mathb}{"00}% name to be checked
\DeclareMathSymbol{\dotminus}      {2}{mathb}{"01}
\DeclareMathSymbol{\dottimes}      {2}{mathb}{"02}% name to be checked
\DeclareMathSymbol{\minusdot}      {2}{mathb}{"03}
\DeclareMathSymbol{\udot}          {2}{mathb}{"04}% name to be checked
\DeclareMathSymbol{\square}        {2}{mathb}{"05}% name to be checked
\DeclareMathSymbol{\Asterisk}      {2}{mathb}{"06}
\DeclareMathSymbol{\bigast}        {1}{mathb}{"06}
\DeclareMathSymbol{\coAsterisk}    {2}{mathb}{"07}
\DeclareMathSymbol{\bigcoast}      {1}{mathb}{"07}
\DeclareMathSymbol{\circplus}      {2}{mathb}{"08}% name to be checked
\DeclareMathSymbol{\pluscirc}      {2}{mathb}{"09}% name to be checked
\DeclareMathSymbol{\convolution}   {2}{mathb}{"0A}% name to be checked
\DeclareMathSymbol{\divideontimes} {2}{mathb}{"0B}% name to be checked
\DeclareMathSymbol{\blackdiamond}  {2}{mathb}{"0C}% name to be checked
\DeclareMathSymbol{\sqbullet}      {2}{mathb}{"0D}% name to be checked
	\mathabx@aliases\sqbullet\centerdot
\DeclareMathSymbol{\bigstar}       {2}{mathb}{"0E}
\DeclareMathSymbol{\bigvarstar}    {2}{mathb}{"0F}
%
\mathabx@verbose{\noindent The symbols {\tt\string\dotminus},
{\tt\string\dottimes} and {\tt\string\minusdot} have been suggested
in a STIX submission [STIX98]. Anyway, it was natural to design them
in {\it mathb} since they are some kinds of duals of the
corresponding symbols in {\it matha}.

The symbol {\tt\string\udot} should have been mentionned somewhere as
a ``capital letter centered dot'', thus it is clear to understand for
what it has been designed: just compare $A\cdot B$ which has been
coded with {\tt\string\cdot} and $A\udot B$.

There is nothing much to say about asterisks: they remain in {\it
mathb}\/ because they are already in {\it matha}. Also, one can look
at the following:
$$
	x_1*\cdots*x_m=\bigast_{i=1}^m x_i
	\qquad\hbox{and}\qquad
	y_1\coast\cdots\coast y_n=\bigcoast_{j=1}^n y_i
$$
which is meaningless but cute. Otherwise, large asterisks are well
suited for use as binary operators ($X\coAsterisk Y$).

The symbols {\tt\string\circplus} and {\tt\string\pluscirc} can be
found in the fonts tables of {\it The Printing of Mathematics},
T.W.~Chaudy, P.R.~Barret and C.~Batey, Oxford University Press,
third impression (1965) [PoM]; the
symbol {\tt\string\convolution} may be renamed. I saw it once in one
of my undergraduate books; {\tt\string\blackdiamond} is just the dual
of {\tt\string\diamond}; {\tt\string\sqbullet} is obvious but its
alias {\tt\string\centerdot} is not (in fact I don't know what AMS
intended to do with this one); {\tt\string\bigstar} is just more
reasonnable than the former one; and at last {\tt\string\bigvarstar}
ows its existence to the one of {\tt\string\varstar}.}%
\end@mathabx
%
\mathabx@matha
\mathabx@verbose{\paragraph{Usual relations (matha)}
There is almost nothing to say about these relation symbols.
{\tt\string\cong} was formerly built from to other symbols
({\tt\string\sim} and {\tt=}), that's why it appears on the right
drawn with the corresponding {\it mathabx}\/ symbols.}%
%
\DeclareMathSymbol{=}              {3}{matha}{"10}
\DeclareMathSymbol{\equiv}         {3}{matha}{"11}
\DeclareMathSymbol{\sim}           {3}{matha}{"12}
\DeclareMathSymbol{\approx}        {3}{matha}{"13}
\DeclareMathSymbol{\simeq}         {3}{matha}{"14}
\mathabx@undefine{\cong}%
\DeclareMathSymbol{\cong}          {3}{matha}{"15}
\DeclareMathSymbol{\asymp}         {3}{matha}{"16}
\DeclareMathSymbol{\divides}       {3}{matha}{"17}
%
\mathabx@undefine{\neq}%
\DeclareMathSymbol{\neq}           {3}{matha}{"18}
	\mathabx@aliases\neq\ne
\DeclareMathSymbol{\notequiv}      {3}{matha}{"19}
	\mathabx@aliases\notequiv\nequiv
\DeclareMathSymbol{\nsim}          {3}{matha}{"1A}
\DeclareMathSymbol{\napprox}       {3}{matha}{"1B}
\DeclareMathSymbol{\nsimeq}        {3}{matha}{"1C}
\DeclareMathSymbol{\ncong}         {3}{matha}{"1D}
\DeclareMathSymbol{\notasymp}      {3}{matha}{"1E}
\DeclareMathSymbol{\notdivides}    {3}{matha}{"1F}
	\mathabx@aliases\notdivides\ndivides
%
%\DeclareMathSymbol{\approxeq}     {3}{matha}{"1C}% name to be checked
%\DeclareMathSymbol{\eqsim}        {3}{matha}{"1E}% name to be checked
%\DeclareMathSymbol{\napproxeq}    {3}{matha}{"1D}
%\DeclareMathSymbol{\neqsim}       {3}{matha}{"1F}
%
\mathabx@verbose{\noindent The negated relations are also
defined. Thus, according to a former paragraph,
{\tt\string\not\string\sim} would be replaced by {\tt\string\nsim}
($\not\sim$) but {\tt\string\not=} would be replaced by
{\tt\string\notsign=} ($\not=$ to which one should prefer
$\neq$). Furthermore, {\tt\string\varnot\string\sim} would be replaced
by {\tt\string\varnotsign\string\sim} ($\varnot\sim$).  If one
exchanges the negation signs with {\tt\string\changenotsign}, one gets
{\changenotsign $\not\sim$ and $\not=$ with the {\tt\string\not}
control sequence, but $\varnot\sim$ and $\varnot=$ with
{\tt\string\varnot}}.}%
\end@mathabx
%
\mathabx@mathb
\mathabx@verbose{\paragraph{Unusual relations (mathb)}
The next relation symbols look really uncommon to me.
But there was a time when some discussion group proposed
such symbols.}%
%
\DeclareMathSymbol{\topdoteq}      {3}{mathb}{"10}% name to be checked
\DeclareMathSymbol{\botdoteq}      {3}{mathb}{"11}% name to be checked
\DeclareMathSymbol{\dotseq}        {3}{mathb}{"12}% name to be checked
	\mathabx@aliases\dotseq{\doteqdot\Doteq}%
\DeclareMathSymbol{\risingdotseq}  {3}{mathb}{"13}% name to be checked
\DeclareMathSymbol{\fallingdotseq} {3}{mathb}{"14}% name to be checked
\DeclareMathSymbol{\coloneq}       {3}{mathb}{"15}% name to be checked
\DeclareMathSymbol{\eqcolon}       {3}{mathb}{"16}% name to be checked
\DeclareMathSymbol{\bumpedeq}      {3}{mathb}{"17}% name to be checked
\DeclareMathSymbol{\eqbumped}      {3}{mathb}{"18}% name to be checked
\DeclareMathSymbol{\Bumpedeq}      {3}{mathb}{"19}% name to be checked
\DeclareMathSymbol{\circeq}        {3}{mathb}{"1A}% name to be checked
\DeclareMathSymbol{\eqcirc}        {3}{mathb}{"1B}% name to be checked
\DeclareMathSymbol{\triangleq}     {3}{mathb}{"1C}% name to be checked
\DeclareMathSymbol{\corresponds}   {3}{mathb}{"1D}% name to be checked
%
\mathabx@verbose{\noindent They are not negated because they are too
unusual. To obtain the negation one has to choose between
{\tt\string\not} and {\tt\string\varnot}. For instance,
$a\not\risingdotseq b$ and $a\varnot\topdoteq b$.}%
\end@mathabx
%
\mathabx@matha
\mathabx@verbose{\paragraph{Miscellaneous (matha)}
Here is a list of various symbols: quite common ordinary ones
and logical relations.}%
%
\DeclareMathSymbol{\neg}           {0}{matha}{"20}
	\mathabx@aliases\neg\lnot
\DeclareMathSymbol{\hash}          {0}{matha}{"23}
\DeclareMathSymbol{\vdash}         {3}{matha}{"24}
\DeclareMathSymbol{\dashv}         {3}{matha}{"25}
\DeclareMathSymbol{\nvdash}        {3}{matha}{"26}
\DeclareMathSymbol{\ndashv}        {3}{matha}{"27}
\DeclareMathSymbol{\vDash}         {3}{matha}{"28}
\DeclareMathSymbol{\Dashv}         {3}{matha}{"29}
\DeclareMathSymbol{\nvDash}        {3}{matha}{"2A}
\DeclareMathSymbol{\nDashv}        {3}{matha}{"2B}
\DeclareMathSymbol{\Vdash}         {3}{matha}{"2C}
\DeclareMathSymbol{\dashV}         {3}{matha}{"2D}
\DeclareMathSymbol{\nVdash}        {3}{matha}{"2E}
\DeclareMathSymbol{\ndashV}        {3}{matha}{"2F}
%
\DeclareMathSymbol{\degree}        {0}{matha}{"30}
\mathabx@undefine{\prime}%
\DeclareMathSymbol{\prime}         {0}{matha}{"31}
\DeclareMathSymbol{\second}        {0}{matha}{"32}
\DeclareMathSymbol{\third}         {0}{matha}{"33}
\DeclareMathSymbol{\fourth}        {0}{matha}{"34}
\DeclareMathSymbol{\flat}          {0}{matha}{"35}
\DeclareMathSymbol{\natural}       {0}{matha}{"36}
\DeclareMathSymbol{\sharp}         {0}{matha}{"37}
\DeclareMathSymbol{\infty}         {0}{matha}{"38}
\DeclareMathSymbol{\propto}        {3}{matha}{"39}
\DeclareMathSymbol{\dagger}        {0}{matha}{"3A}
\DeclareMathSymbol{\ddagger}       {0}{matha}{"3B}
%
\mathabx@verbose{\noindent
Nous avons r\'eintroduit les signes {\tt\string\prime}
multiples associ\'es aux commandes {\tt\string\prime},
{\tt\string\second}, {\tt\string\third} et {\tt\string\fourth}.
Une commande naturellement associ\'ee est {\tt\string\degree}
correspondant \`a un symbole semblable \`a celui appel\'e
par {\tt\string\circ}. Il est n\'eanmoins diff\'erent car
il doit \^etre homog\`ene \`a l'ensemble des symboles
pr\'ec\'edents (comparer $44^\circ$ et $44^\degree$).
$$
	44^\degree+36^\prime+89^\second+46^\third+99^\fourth
$$
La construction habituelle ({\it i.e.}\/ {\tt 99''''})
supporte une propri\'et\'e de ligaturage
sur les caract\`eres correspondants.
C'est ce que l'on voit ci-dessous~:
$$
	44^\degree+36'+89''+46'''+99'''',\qquad\hbox{mais}\quad99'''''
	\quad\hbox{ou}\quad99''''''''.
$$
(Il faut y regarder de tr\`es pr\`es pour y voir
ce qu'il faut voir\dots)}%
\end@mathabx
%
\mathabx@mathb
\mathabx@verbose{\paragraph{Miscellaneous (mathb)}}%
%
\DeclareMathSymbol{\between}       {3}{mathb}{"20}
\DeclareMathSymbol{\smile}         {3}{mathb}{"21}
\DeclareMathSymbol{\frown}         {3}{mathb}{"22}
\DeclareMathSymbol{\varhash}       {0}{mathb}{"23}
\DeclareMathSymbol{\leftthreetimes} {0}{mathb}{"24}
\DeclareMathSymbol{\rightthreetimes}{0}{mathb}{"25}
\DeclareMathSymbol{\pitchfork}     {0}{mathb}{"26}
\mathabx@undefine{\bowtie}%
\DeclareMathSymbol{\bowtie}        {3}{mathb}{"27}
	\mathabx@aliases\bowtie\Join
\DeclareMathSymbol{\VDash}         {3}{mathb}{"28}
\DeclareMathSymbol{\DashV}         {3}{mathb}{"29}
\DeclareMathSymbol{\nVDash}        {3}{mathb}{"2A}
\DeclareMathSymbol{\nDashV}        {3}{mathb}{"2B}
\DeclareMathSymbol{\Vvdash}        {3}{mathb}{"2C}
\DeclareMathSymbol{\dashVv}        {3}{mathb}{"2D}
\DeclareMathSymbol{\nVvash}        {3}{mathb}{"2E}
\DeclareMathSymbol{\ndashVv}       {3}{mathb}{"2F}
%
\DeclareMathSymbol{\therefore}     {3}{mathb}{"36}
\DeclareMathSymbol{\because}       {3}{mathb}{"37}
\DeclareMathAccent{\ring}          {0}{mathb}{"38}
\mathabx@undefine{\dot}%
\DeclareMathAccent{\dot}           {0}{mathb}{"39}
\mathabx@undefine{\ddot}%
\DeclareMathAccent{\ddot}          {0}{mathb}{"3A}
\mathabx@undefine{\dddot}%
\DeclareMathAccent{\dddot}         {0}{mathb}{"3B}
\mathabx@undefine{\ddddot}%
\DeclareMathAccent{\ddddot}        {0}{mathb}{"3C}
\mathabx@undefine{\angle}%
\DeclareMathSymbol{\angle}         {0}{mathb}{"3D}
\DeclareMathSymbol{\measuredangle} {0}{mathb}{"3E}
\DeclareMathSymbol{\sphericalangle}{0}{mathb}{"3F}
\DeclareMathSymbol{\rip}           {0}{mathb}{"4F}
\mathabx@verbose{\noindent 
The {\tt\string\rip} sign is mostly for fun. It is not an
astronomical/logical symbol but is located among them in {\it
mathb}. In the Theory of Markov Processes, a cemetery sign is often
needed. We have designed the following ugly and not so necessary one:
$\rip{}\rip\rip\rip$. Many successive {\tt\string\rip} signs glue to
each others.}%
\end@mathabx
%
\mathabx@matha
\mathabx@verbose{\paragraph{Delimiters as symbols (matha)}}%
%
\DeclareMathSymbol{(}              {4}{matha}{"70}
\DeclareMathSymbol{)}              {5}{matha}{"71}
\DeclareMathSymbol{[}              {4}{matha}{"72}
\DeclareMathSymbol{]}              {5}{matha}{"73}
%\DeclareMathSymbol{\lbrace}       {4}{matha}{"74}% extens. delimiter
%\DeclareMathSymbol{\rbrace}       {5}{matha}{"75}% extens. delimiter
% \mathabx@undefine{\backslash}
% \DeclareMathSymbol{\backslash}   {0}{matha}{"7A}% extens. delimiter
\DeclareMathSymbol{\setminus}      {0}{matha}{"7A}
\DeclareMathSymbol{/}              {0}{matha}{"7B}
\DeclareMathSymbol{|}              {0}{matha}{"7C}
\DeclareMathSymbol{\mid}           {3}{matha}{"7C}
% \DeclareMathSymbol{\|}           {0}{matha}{"7D}% extens. delimiter
% \DeclareMathSymbol{\vvvert}      {0}{matha}{"7E}% extens. delimiter
%
\mathabx@verbose{\noindent The only thing one should notice here is
that {\tt\string\setminus} is defined here as an ordinary
symbol. There are two reasons for that: division as the slash symbol
({\tt/}) has also an ordinary value; spacing with
{\tt\string\setminus} defined has a binary operator is too large for
my own taste.}
\end@mathabx
%
\mathabx@mathb
\mathabx@verbose{\paragraph{Delimiters as symbols (mathb)}
The following delimiters have no extensible versions.}%
%
\DeclareMathSymbol{\lcorners}      {4}{mathb}{"76}% name to be checked
\DeclareMathSymbol{\rcorners}      {5}{mathb}{"77}% name to be checked
\mathabx@undefine{\ulcorner}%
\DeclareMathSymbol{\ulcorner}      {4}{mathb}{"78}% name to be checked
\mathabx@undefine{\urcorner}%
\DeclareMathSymbol{\urcorner}      {5}{mathb}{"79}% name to be checked
\mathabx@undefine{\llcorner}%
\DeclareMathSymbol{\llcorner}      {4}{mathb}{"7A}% name to be checked
\mathabx@undefine{\lrcorner}%
\DeclareMathSymbol{\lrcorner}      {5}{mathb}{"7B}% name to be checked
%
\mathabx@verbose{\paragraph{Astronomical and astrological symbols (mathb)}
The set of astronomical/logical symbols is not complete. It will certainly
be moved in the future to some {\it mathf}\/ or {\it mathg}\/ series (Funny or Games). ({\it mathd}\/ may be reserved for double stroked or blackboard fonts [mbb] by the same author).}%
%
\DeclareMathSymbol{\Sun}           {0}{mathb}{"40}
\DeclareMathSymbol{\Mercury}       {0}{mathb}{"41}
\DeclareMathSymbol{\Venus}         {0}{mathb}{"42}
	\mathabx@aliases\Venus\girl
\DeclareMathSymbol{\Earth}         {0}{mathb}{"43}
\DeclareMathSymbol{\Mars}          {0}{mathb}{"44}
	\mathabx@aliases\Mars\boy
\DeclareMathSymbol{\Jupiter}       {0}{mathb}{"45}
\DeclareMathSymbol{\Saturn}        {0}{mathb}{"46}
\DeclareMathSymbol{\Uranus}        {0}{mathb}{"47}
\DeclareMathSymbol{\Neptune}       {0}{mathb}{"48}
\DeclareMathSymbol{\Pluto}         {0}{mathb}{"49}
\DeclareMathSymbol{\varEarth}      {0}{mathb}{"4A}
\DeclareMathSymbol{\leftmoon}      {0}{mathb}{"4B}
	\mathabx@aliases\leftmoon\Moon
\DeclareMathSymbol{\rightmoon}     {0}{mathb}{"4C}
\DeclareMathSymbol{\fullmoon}      {0}{mathb}{"4D}
\DeclareMathSymbol{\newmoon}       {0}{mathb}{"4E}
%
\DeclareMathSymbol{\Aries}         {0}{mathb}{"50}
\DeclareMathSymbol{\Taurus}        {0}{mathb}{"51}
\DeclareMathSymbol{\Gemini}        {0}{mathb}{"52}
%\DeclareMathSymbol{\Cancer}      {0}{mathb}{"53}
\DeclareMathSymbol{\Leo}         {0}{mathb}{"54}
%\DeclareMathSymbol{\Virgo}       {0}{mathb}{"55}
\DeclareMathSymbol{\Libra}         {0}{mathb}{"56}
\DeclareMathSymbol{\Scorpio}       {0}{mathb}{"57}
%\DeclareMathSymbol{\Sagittarius} {0}{mathb}{"58}
%\DeclareMathSymbol{\Capricornus} {0}{mathb}{"59}
%\DeclareMathSymbol{\Aquarius}    {0}{mathb}{"59}
%\DeclareMathSymbol{\Pisces}      {0}{mathb}{"59}
\end@mathabx
%
\mathabx@matha
\mathabx@verbose{\paragraph{Letter like symbols (matha)}}%
%
\DeclareMathSymbol{\forall}        {0}{matha}{"40}
\DeclareMathSymbol{\complement}    {0}{matha}{"41}
\DeclareMathSymbol{\partial}       {0}{matha}{"42}
%	\mathabx@aliases\partial\partialit
\DeclareMathSymbol{\partialslash}  {0}{matha}{"43}
\DeclareMathSymbol{\exists}        {0}{matha}{"44}
\DeclareMathSymbol{\nexists}       {0}{matha}{"45}
\DeclareMathSymbol{\Finv}          {0}{matha}{"46}
\DeclareMathSymbol{\Game}          {0}{matha}{"47}
\DeclareMathSymbol{\emptyset}      {0}{matha}{"48}
\DeclareMathSymbol{\diameter}      {0}{matha}{"49}
\DeclareMathSymbol{\top}           {0}{matha}{"4A}
\DeclareMathSymbol{\bot}           {0}{matha}{"4B}
\DeclareMathSymbol{\perp}          {3}{matha}{"4B}
\DeclareMathSymbol{\nottop}        {0}{matha}{"4C}
\DeclareMathSymbol{\notbot}        {0}{matha}{"4D}
\DeclareMathSymbol{\notperp}       {3}{matha}{"4D}
\DeclareMathSymbol{\curlywedge}    {2}{matha}{"4E}
\DeclareMathSymbol{\curlyvee}      {2}{matha}{"4F}
%
\DeclareMathSymbol{\in}            {3}{matha}{"50}
\DeclareMathSymbol{\owns}          {3}{matha}{"51}
	\mathabx@aliases\owns\ni
\mathabx@undefine{\notin}%
\DeclareMathSymbol{\notin}         {3}{matha}{"52}
\DeclareMathSymbol{\notowner}      {3}{matha}{"53}
	\mathabx@aliases\notowner{\notni\notowns}%
\DeclareMathSymbol{\varnotin}      {3}{matha}{"54}
\DeclareMathSymbol{\varnotowner}   {3}{matha}{"55}
\DeclareMathSymbol{\barin}         {3}{matha}{"56}% name to be checked
\DeclareMathSymbol{\ownsbar}       {3}{matha}{"57}% name to be checked
	\mathabx@aliases\ownsbar\nibar% Arghl
%
\DeclareMathSymbol{\cap}           {2}{matha}{"58}
\DeclareMathSymbol{\cup}           {2}{matha}{"59}
\DeclareMathSymbol{\uplus}         {2}{matha}{"5A}
\DeclareMathSymbol{\sqcap}         {2}{matha}{"5B}
\DeclareMathSymbol{\sqcup}         {2}{matha}{"5C}
\DeclareMathSymbol{\squplus}       {2}{matha}{"5D}
\DeclareMathSymbol{\wedge}         {2}{matha}{"5E}
	\mathabx@aliases\wedge\land
\DeclareMathSymbol{\vee}           {2}{matha}{"5F}
	\mathabx@aliases\vee\lor
\end@mathabx
%
\mathabx@mathb
\mathabx@verbose{\paragraph{Letter like symbols (mathb)}}%
%
\DeclareMathSymbol{\barwedge}      {2}{mathb}{"58}
\DeclareMathSymbol{\veebar}        {2}{mathb}{"59}
\DeclareMathSymbol{\doublebarwedge}{2}{mathb}{"5A}
\DeclareMathSymbol{\veedoublebar}  {2}{mathb}{"5B}
\DeclareMathSymbol{\doublecap}     {2}{mathb}{"5C}
	\mathabx@aliases\doublecap\Cap
\DeclareMathSymbol{\doublecup}     {2}{mathb}{"5D}
	\mathabx@aliases\doublecup\Cup
\DeclareMathSymbol{\sqdoublecap}   {2}{mathb}{"5E}
	\mathabx@aliases\sqdoublecap\sqCap
\DeclareMathSymbol{\sqdoublecup}   {2}{mathb}{"5F}
	\mathabx@aliases\sqdoublecup\sqCup
\end@mathabx
%
\mathabx@matha
\mathabx@verbose{\paragraph{Subset's and superset's signs (matha)}}%
%
\DeclareMathSymbol{\subset}        {3}{matha}{"80}
\DeclareMathSymbol{\supset}        {3}{matha}{"81}
\DeclareMathSymbol{\nsubset}       {3}{matha}{"82}
\DeclareMathSymbol{\nsupset}       {3}{matha}{"83}
\DeclareMathSymbol{\subseteq}      {3}{matha}{"84}
\DeclareMathSymbol{\supseteq}      {3}{matha}{"85}
\DeclareMathSymbol{\nsubseteq}     {3}{matha}{"86}
\DeclareMathSymbol{\nsupseteq}     {3}{matha}{"87}
\DeclareMathSymbol{\subsetneq}     {3}{matha}{"88}
\DeclareMathSymbol{\supsetneq}     {3}{matha}{"89}
\DeclareMathSymbol{\varsubsetneq}  {3}{matha}{"8A}
\DeclareMathSymbol{\varsupsetneq}  {3}{matha}{"8B}
%
\DeclareMathSymbol{\subseteqq}     {3}{matha}{"8C}
\DeclareMathSymbol{\supseteqq}     {3}{matha}{"8D}
\DeclareMathSymbol{\nsubseteqq}    {3}{matha}{"8E}
\DeclareMathSymbol{\nsupseteqq}    {3}{matha}{"8F}
\DeclareMathSymbol{\subsetneqq}    {3}{matha}{"90}
\DeclareMathSymbol{\supsetneqq}    {3}{matha}{"91}
\DeclareMathSymbol{\varsubsetneqq} {3}{matha}{"92}
\DeclareMathSymbol{\varsupsetneqq} {3}{matha}{"93}
%
\DeclareMathSymbol{\Subset}        {3}{matha}{"94}
\DeclareMathSymbol{\Supset}        {3}{matha}{"95}
\DeclareMathSymbol{\nSubset}       {3}{matha}{"96}
\DeclareMathSymbol{\nSupset}       {3}{matha}{"97}
\end@mathabx
%
\mathabx@mathb
\mathabx@verbose{\paragraph{Square subset's and superset's signs (mathb)}}%
\mathabx@undefine{\sqsubset}%
\DeclareMathSymbol{\sqsubset}       {3}{mathb}{"80}
\mathabx@undefine{\sqsupset}%
\DeclareMathSymbol{\sqsupset}       {3}{mathb}{"81}
\DeclareMathSymbol{\nsqsubset}      {3}{mathb}{"82}
\DeclareMathSymbol{\nsqsupset}      {3}{mathb}{"83}
\DeclareMathSymbol{\sqsubseteq}     {3}{mathb}{"84}
\DeclareMathSymbol{\sqsupseteq}     {3}{mathb}{"85}
\DeclareMathSymbol{\nsqsubseteq}    {3}{mathb}{"86}
\DeclareMathSymbol{\nsqsupseteq}    {3}{mathb}{"87}
\DeclareMathSymbol{\sqsubsetneq}    {3}{mathb}{"88}
\DeclareMathSymbol{\sqsupsetneq}    {3}{mathb}{"89}
\DeclareMathSymbol{\varsqsubsetneq} {3}{mathb}{"8A}
\DeclareMathSymbol{\varsqsupsetneq} {3}{mathb}{"8B}
%
\DeclareMathSymbol{\sqsubseteqq}    {3}{mathb}{"8C}
\DeclareMathSymbol{\sqsupseteqq}    {3}{mathb}{"8D}
\DeclareMathSymbol{\nsqsubseteqq}   {3}{mathb}{"8E}
\DeclareMathSymbol{\nsqsupseteqq}   {3}{mathb}{"8F}
\DeclareMathSymbol{\sqsubsetneqq}   {3}{mathb}{"90}
\DeclareMathSymbol{\sqsupsetneqq}   {3}{mathb}{"91}
\DeclareMathSymbol{\varsqsubsetneqq}{3}{mathb}{"92}
\DeclareMathSymbol{\varsqsupsetneqq}{3}{mathb}{"93}
%
\DeclareMathSymbol{\sqSubset}       {3}{mathb}{"94}
\DeclareMathSymbol{\sqSupset}       {3}{mathb}{"95}
\DeclareMathSymbol{\nsqSubset}      {3}{mathb}{"96}
\DeclareMathSymbol{\nsqSupset}      {3}{mathb}{"97}
\end@mathabx
%
\mathabx@matha
\mathabx@verbose{\paragraph{Triangles as relations (matha)}}%
%
\DeclareMathSymbol{\triangleleft}    {2}{matha}{"98}
\DeclareMathSymbol{\vartriangleleft} {3}{matha}{"98}
\DeclareMathSymbol{\triangleright}   {2}{matha}{"99}
\DeclareMathSymbol{\vartriangleright}{3}{matha}{"99}
\DeclareMathSymbol{\ntriangleleft}   {3}{matha}{"9A}
\DeclareMathSymbol{\ntriangleright}  {3}{matha}{"9B}
\DeclareMathSymbol{\trianglelefteq}  {3}{matha}{"9C}
\DeclareMathSymbol{\trianglerighteq} {3}{matha}{"9D}
\DeclareMathSymbol{\ntrianglelefteq} {3}{matha}{"9E}
\DeclareMathSymbol{\ntrianglerighteq}{3}{matha}{"9F}
\end@mathabx
%
\mathabx@mathb
\mathabx@verbose{\paragraph{Triangles as binary operators (mathb)}}%
%
\DeclareMathSymbol{\smalltriangleup}   {2}{mathb}{"98}% name to be checked
\DeclareMathSymbol{\smalltriangledown} {2}{mathb}{"99}% name to be checked
\DeclareMathSymbol{\smalltriangleleft} {2}{mathb}{"9A}% name to be checked
\DeclareMathSymbol{\smalltriangleright}{2}{mathb}{"9B}% name to be checked
\DeclareMathSymbol{\blacktriangleup}   {2}{mathb}{"9C}% name to be checked
\DeclareMathSymbol{\blacktriangledown} {2}{mathb}{"9D}% name to be checked
\DeclareMathSymbol{\blacktriangleleft} {2}{mathb}{"9E}% name to be checked
\DeclareMathSymbol{\blacktriangleright}{2}{mathb}{"9F}% name to be checked
\end@mathabx
%
\mathabx@matha
\mathabx@verbose{\paragraph{Inequalities (matha)}}%
%
\DeclareMathSymbol{\ll}          {3}{matha}{"21}
\DeclareMathSymbol{\gg}          {3}{matha}{"22}
\DeclareMathSymbol{<}            {3}{matha}{"A0}
\DeclareMathSymbol{>}            {3}{matha}{"A1}
\DeclareMathSymbol{\nless}       {3}{matha}{"A2}
\DeclareMathSymbol{\ngtr}        {3}{matha}{"A3}
\DeclareMathSymbol{\leq}         {3}{matha}{"A4}
	\mathabx@aliases\leq{\le\leqslant}%
\DeclareMathSymbol{\geq}         {3}{matha}{"A5}
	\mathabx@aliases\geq{\ge\geqslant}%
\DeclareMathSymbol{\nleq}        {3}{matha}{"A6}
	\mathabx@aliases\nleq\nleqslant 
\DeclareMathSymbol{\ngeq}        {3}{matha}{"A7}
	\mathabx@aliases\ngeq\ngeqslant
\DeclareMathSymbol{\varleq}      {3}{matha}{"A8}
\DeclareMathSymbol{\vargeq}      {3}{matha}{"A9}
\DeclareMathSymbol{\nvarleq}     {3}{matha}{"AA}
\DeclareMathSymbol{\nvargeq}     {3}{matha}{"AB}
\DeclareMathSymbol{\lneq}        {3}{matha}{"AC}
\DeclareMathSymbol{\gneq}        {3}{matha}{"AD}
\DeclareMathSymbol{\leqq}        {3}{matha}{"AE}
\DeclareMathSymbol{\geqq}        {3}{matha}{"AF}
\DeclareMathSymbol{\nleqq}       {3}{matha}{"B0}
\DeclareMathSymbol{\ngeqq}       {3}{matha}{"B1}
\DeclareMathSymbol{\lneqq}       {3}{matha}{"B2}
\DeclareMathSymbol{\gneqq}       {3}{matha}{"B3}
\DeclareMathSymbol{\lvertneqq}   {3}{matha}{"B4}
\DeclareMathSymbol{\gvertneqq}   {3}{matha}{"B5}
\DeclareMathSymbol{\eqslantless} {3}{matha}{"B6}
\DeclareMathSymbol{\eqslantgtr}  {3}{matha}{"B7}
\DeclareMathSymbol{\neqslantless}{3}{matha}{"B8}
\DeclareMathSymbol{\neqslantgtr} {3}{matha}{"B9}
\DeclareMathSymbol{\lessgtr}     {3}{matha}{"BA}
\DeclareMathSymbol{\gtrless}     {3}{matha}{"BB}
\DeclareMathSymbol{\lesseqgtr}   {3}{matha}{"BC}
\DeclareMathSymbol{\gtreqless}   {3}{matha}{"BD}
\DeclareMathSymbol{\lesseqqgtr}  {3}{matha}{"BE}
\DeclareMathSymbol{\gtreqqless}  {3}{matha}{"BF}
%
\DeclareMathSymbol{\lesssim}     {3}{matha}{"C0}
\DeclareMathSymbol{\gtrsim}      {3}{matha}{"C1}
\DeclareMathSymbol{\nlesssim}    {3}{matha}{"C2}
\DeclareMathSymbol{\ngtrsim}     {3}{matha}{"C3}
\DeclareMathSymbol{\lnsim}       {3}{matha}{"C4}
\DeclareMathSymbol{\gnsim}       {3}{matha}{"C5}
\DeclareMathSymbol{\lessapprox}  {3}{matha}{"C6}
\DeclareMathSymbol{\gtrapprox}   {3}{matha}{"C7}
\DeclareMathSymbol{\nlessapprox} {3}{matha}{"C8}
\DeclareMathSymbol{\ngtrapprox}  {3}{matha}{"C9}
\DeclareMathSymbol{\lnapprox}    {3}{matha}{"CA}
\DeclareMathSymbol{\gnapprox}    {3}{matha}{"CB}
%
\DeclareMathSymbol{\lessdot}     {3}{matha}{"CC}
\DeclareMathSymbol{\gtrdot}      {3}{matha}{"CD}
%
\DeclareMathSymbol{\lll}         {3}{matha}{"CE}
\DeclareMathSymbol{\ggg}         {3}{matha}{"CF}
\end@mathabx
%
\mathabx@mathb
\mathabx@verbose{\paragraph{Inequalities (mathb)}}%
%
\DeclareMathSymbol{\prec}        {3}{mathb}{"A0}
\DeclareMathSymbol{\succ}        {3}{mathb}{"A1}
\DeclareMathSymbol{\nprec}       {3}{mathb}{"A2}
\DeclareMathSymbol{\nsucc}       {3}{mathb}{"A3}
\DeclareMathSymbol{\preccurlyeq} {3}{mathb}{"A4}
\DeclareMathSymbol{\succcurlyeq} {3}{mathb}{"A5}
\DeclareMathSymbol{\npreccurlyeq}{3}{mathb}{"A6}
\DeclareMathSymbol{\nsucccurlyeq}{3}{mathb}{"A7}
\DeclareMathSymbol{\preceq}      {3}{mathb}{"A8}
\DeclareMathSymbol{\succeq}      {3}{mathb}{"A9}
\DeclareMathSymbol{\npreceq}     {3}{mathb}{"AA}
\DeclareMathSymbol{\nsucceq}     {3}{mathb}{"AB}
\DeclareMathSymbol{\precneq}     {3}{mathb}{"AC}
\DeclareMathSymbol{\succneq}     {3}{mathb}{"AD}
\DeclareMathSymbol{\curlyeqprec} {3}{mathb}{"B6}
\DeclareMathSymbol{\curlyeqsucc} {3}{mathb}{"B7}
\DeclareMathSymbol{\ncurlyeqprec}{3}{mathb}{"B8}
\DeclareMathSymbol{\ncurlyeqsucc}{3}{mathb}{"B9}
%
\DeclareMathSymbol{\precsim}     {3}{mathb}{"C0}
\DeclareMathSymbol{\succsim}     {3}{mathb}{"C1}
\DeclareMathSymbol{\nprecsim}    {3}{mathb}{"C2}
\DeclareMathSymbol{\nsuccsim}    {3}{mathb}{"C3}
\DeclareMathSymbol{\precnsim}    {3}{mathb}{"C4}
\DeclareMathSymbol{\succnsim}    {3}{mathb}{"C5}
\DeclareMathSymbol{\precapprox}  {3}{mathb}{"C6}
\DeclareMathSymbol{\succapprox}  {3}{mathb}{"C7}
\DeclareMathSymbol{\nprecapprox} {3}{mathb}{"C8}
\DeclareMathSymbol{\nsuccapprox} {3}{mathb}{"C9}
\DeclareMathSymbol{\precnapprox} {3}{mathb}{"CA}
\DeclareMathSymbol{\succnapprox} {3}{mathb}{"CB}
%
\DeclareMathSymbol{\precdot}     {3}{mathb}{"CC}
\DeclareMathSymbol{\succdot}      {3}{mathb}{"CD}
\DeclareMathSymbol{\llcurly}     {3}{mathb}{"CE}
\DeclareMathSymbol{\ggcurly}     {3}{mathb}{"CF}
%
% \DeclareMathSymbol{\leftthreetimes} {3}{mathb}{"56}
% \DeclareMathSymbol{\rightthreetimes}{3}{mathb}{"57}
\end@mathabx
%
\mathabx@matha
\mathabx@verbose{\paragraph{Arrows and harpoons (matha)}}%
%
\DeclareMathSymbol{\leftarrow}             {3}{matha}{"D0}
	\mathabx@aliases\leftarrow\gets
\DeclareMathSymbol{\rightarrow}            {3}{matha}{"D1}
	\mathabx@aliases\rightarrow\to
% \DeclareMathSymbol{\uparrow}             {3}{matha}{"D2}
% \DeclareMathSymbol{\downarrow}           {3}{matha}{"D3}
\DeclareMathSymbol{\nwarrow}               {3}{matha}{"D4}
\DeclareMathSymbol{\nearrow}               {3}{matha}{"D5}
\DeclareMathSymbol{\swarrow}               {3}{matha}{"D6}
\DeclareMathSymbol{\searrow}               {3}{matha}{"D7}
\DeclareMathSymbol{\leftrightarrow}        {3}{matha}{"D8}
% \DeclareMathSymbol{\updownarrow}         {3}{matha}{"D9}
\DeclareMathSymbol{\nleftarrow}            {3}{matha}{"DA}
\DeclareMathSymbol{\nrightarrow}           {3}{matha}{"DB}
\DeclareMathSymbol{\nleftrightarrow}       {3}{matha}{"DC}
%
\DeclareMathSymbol{\leftharpoonup}         {3}{matha}{"E0}
\DeclareMathSymbol{\rightharpoonup}        {3}{matha}{"E1}
\DeclareMathSymbol{\leftharpoondown}       {3}{matha}{"E2}
\DeclareMathSymbol{\rightharpoondown}      {3}{matha}{"E3}
\DeclareMathSymbol{\upharpoonleft}         {3}{matha}{"E4}
\DeclareMathSymbol{\downharpoonleft}       {3}{matha}{"E5}
\DeclareMathSymbol{\upharpoonright}        {3}{matha}{"E6}
\DeclareMathSymbol{\restriction}           {0}{matha}{"E6}
\DeclareMathSymbol{\downharpoonright}      {3}{matha}{"E7}
\DeclareMathSymbol{\leftrightharpoons}     {3}{matha}{"E8}
\mathabx@undefine{\rightleftharpoons}%
\DeclareMathSymbol{\rightleftharpoons}     {3}{matha}{"E9}
\DeclareMathSymbol{\updownharpoons}        {3}{matha}{"EA}
\DeclareMathSymbol{\downupharpoons}        {3}{matha}{"EB}
%
\DeclareMathSymbol{\Leftarrow}             {3}{matha}{"F0}
\DeclareMathSymbol{\Rightarrow}            {3}{matha}{"F1}
% \DeclareMathSymbol{\Uparrow}             {3}{matha}{"F2}
% \DeclareMathSymbol{\Downarrow}           {3}{matha}{"F3}
\DeclareMathSymbol{\Leftrightarrow}        {3}{matha}{"F4}
% \DeclareMathSymbol{\Updownarrow}         {3}{matha}{"F5}
\DeclareMathSymbol{\nLeftarrow}            {3}{matha}{"F6}
\DeclareMathSymbol{\nRightarrow}           {3}{matha}{"F7}
\DeclareMathSymbol{\nLeftrightarrow}       {3}{matha}{"F8}
%
\mathabx@verbose{\paragraph{Arrows toolkit (matha)}
This very small arrows kit contains the standard things: left and
right hooks, various maps to or from characters, bars for
extensions. These last ones are different from minus and equal signs
since they are a bit longer (of $1\,\rm mu$ but their actual width are
the same) than them. Short things (in fact arrows heads) are here but
nothing is planned to do with them (they are some adaptation of AMS
corresponding symbols but I just don't know what to do with
them). Tails have been introduced ({\it see}\/ [PoM]), they just
overlap (no {\tt\string\joinrel} needed) the following of preceding
relation character in order to give the aspect of a feathered
arrow. Bricks for negating long arrows (simple, double and harpoons) are also
provided.}%
\DeclareMathSymbol{\shortleftarrow}        {3}{matha}{"EC}% to be checked
\DeclareMathSymbol{\shortrightarrow}       {3}{matha}{"ED}% to be checked
\DeclareMathSymbol{\rhook}                 {3}{matha}{"EE}
\DeclareMathSymbol{\lhook}                 {3}{matha}{"EF}
\mathabx@undefine{\relbar}%
\DeclareMathSymbol{\relbar}                {3}{matha}{"DD}
\DeclareMathSymbol{\notrelbar}             {3}{matha}{"FE}% to be checked
\DeclareMathSymbol{\mapstochar}            {3}{matha}{"DE}
\DeclareMathSymbol{\mapsfromchar}          {3}{matha}{"DF}
\mathabx@undefine{\Relbar}%
\DeclareMathSymbol{\Relbar}                {3}{matha}{"F9}
\DeclareMathSymbol{\notRelbar}             {3}{matha}{"FF}% to be checked
\DeclareMathSymbol{\Mapstochar}            {3}{matha}{"FA}
\DeclareMathSymbol{\Mapsfromchar}          {3}{matha}{"FB}
\DeclareMathSymbol{\leftarrowtailchar}     {3}{matha}{"FC}
\DeclareMathSymbol{\rightarrowtailchar}    {3}{matha}{"FD}
\end@mathabx
\mathabx@verbose{\noindent For instance, one can build
$a\lhook\joinrel\rightarrow b$,
$a\mapstochar\rightarrow b$, $a\rightarrowtailchar\rightarrow b$,
$a\rightarrowtailchar\notrelbar\rightarrow b$,
$a\rightarrowtailchar\rightarrow\mathrel{\mkern0.5mu}\mapsfromchar b$.}
%
\mathabx@mathb
\mathabx@verbose{\paragraph{Arrows and harpoons (mathb)}}%
%
\DeclareMathSymbol{\leftleftarrows}        {3}{mathb}{"D0}
\DeclareMathSymbol{\rightrightarrows}      {3}{mathb}{"D1}
\DeclareMathSymbol{\upuparrows}            {3}{mathb}{"D2}
\DeclareMathSymbol{\downdownarrows}        {3}{mathb}{"D3}
\DeclareMathSymbol{\leftrightarrows}       {3}{mathb}{"D4}
\DeclareMathSymbol{\rightleftarrows}       {3}{mathb}{"D5}
\DeclareMathSymbol{\updownarrows}          {3}{mathb}{"D6}
\DeclareMathSymbol{\downuparrows}          {3}{mathb}{"D7}
\DeclareMathSymbol{\leftleftharpoons}      {3}{mathb}{"D8}
\DeclareMathSymbol{\rightrightharpoons}    {3}{mathb}{"D9}
\DeclareMathSymbol{\upupharpoons}          {3}{mathb}{"DA}
\DeclareMathSymbol{\downdownharpoons}      {3}{mathb}{"DB}
\DeclareMathSymbol{\leftbarharpoon}        {3}{mathb}{"DC}
\DeclareMathSymbol{\rightbarharpoon}       {3}{mathb}{"DD}
\DeclareMathSymbol{\barleftharpoon}        {3}{mathb}{"DE}
\DeclareMathSymbol{\barrightharpoon}       {3}{mathb}{"DF}
\DeclareMathSymbol{\leftrightharpoon}      {3}{mathb}{"E0}
\DeclareMathSymbol{\rightleftharpoon}      {3}{mathb}{"E1}
%
\DeclareMathSymbol{\diagup}                {3}{mathb}{"1E}
\DeclareMathSymbol{\diagdown}              {3}{mathb}{"1F}
%
% All of the following must be checked
%
\DeclareMathSymbol{\originalof}            {3}{mathb}{"E2}
\DeclareMathSymbol{\imageof}               {3}{mathb}{"E3}
\DeclareMathSymbol{\revmultimap}           {3}{mathb}{"E4}
\DeclareMathSymbol{\multimap}              {3}{mathb}{"E5}
\DeclareMathSymbol{\revblackmultimap}      {3}{mathb}{"E6}
\DeclareMathSymbol{\blackmultimap}         {3}{mathb}{"E7}
%
\DeclareMathSymbol{\Lsh}                   {3}{mathb}{"E8}
	\mathabx@aliases\Lsh\ulsh
\DeclareMathSymbol{\Rsh}                   {3}{mathb}{"E9}
	\mathabx@aliases\Rsh\ursh
\DeclareMathSymbol{\dlsh}                  {3}{mathb}{"EA}
\DeclareMathSymbol{\drsh}                  {3}{mathb}{"EB}
%
\DeclareMathSymbol{\looparrowleft}         {3}{mathb}{"EC}
	\mathabx@aliases\looparrowleft\looparrowupleft
\DeclareMathSymbol{\looparrowright}        {3}{mathb}{"ED}
        \mathabx@aliases\looparrowright\looparrowupright
\DeclareMathSymbol{\looparrowdownleft}     {3}{mathb}{"EE}
\DeclareMathSymbol{\looparrowdownright}    {3}{mathb}{"EF}
%
\DeclareMathSymbol{\curvearrowleft}        {3}{mathb}{"F0}
	\mathabx@aliases\curvearrowleft\curvearrowtopleft
\DeclareMathSymbol{\curvearrowright}       {3}{mathb}{"F1}
        \mathabx@aliases\curvearrowright\curvearrowtopright
\DeclareMathSymbol{\curvearrowleftright}   {3}{mathb}{"F2}
        \mathabx@aliases\curvearrowleftright\curvearrowtopleftright
\DeclareMathSymbol{\curvearrowbotleft}     {3}{mathb}{"F3}
\DeclareMathSymbol{\curvearrowbotright}    {3}{mathb}{"F4}
\DeclareMathSymbol{\curvearrowbotleftright}{3}{mathb}{"F5}
%
\DeclareMathSymbol{\circlearrowleft}       {3}{mathb}{"F6}
\DeclareMathSymbol{\circlearrowright}      {3}{mathb}{"F7}
%
\DeclareMathSymbol{\leftsquigarrow}        {3}{mathb}{"F8}
\DeclareMathSymbol{\rightsquigarrow}       {3}{mathb}{"F9}
\DeclareMathSymbol{\leftrightsquigarrow}   {3}{mathb}{"FA}
%\DeclareMathSymbol{????????}              {3}{mathb}{"FB}
%
\DeclareMathSymbol{\lefttorightarrow}      {3}{mathb}{"FC}
\DeclareMathSymbol{\righttoleftarrow}      {3}{mathb}{"FD}
\DeclareMathSymbol{\uptodownarrow}         {3}{mathb}{"FE}
\DeclareMathSymbol{\downtouparrow}         {3}{mathb}{"FF}
\end@mathabx
%
\mathabx@matha
\mathabx@verbose{\paragraph{Circles (matha)}}%
%
\DeclareMathSymbol{\oplus}        {2}{matha}{"60}
\DeclareMathSymbol{\ominus}       {2}{matha}{"61}
	\mathabx@aliases\ominus\circleddash
\DeclareMathSymbol{\otimes}       {2}{matha}{"62}
\DeclareMathSymbol{\odiv}         {2}{matha}{"63}
\DeclareMathSymbol{\odot}         {2}{matha}{"64}
\DeclareMathSymbol{\ocirc}        {2}{matha}{"65}
	\mathabx@aliases\ocirc\circledcirc
\DeclareMathSymbol{\oasterisk}    {2}{matha}{"66}
	\mathabx@aliases\oasterisk\circledast
\DeclareMathSymbol{\ocoasterisk}  {2}{matha}{"67}
\DeclareMathSymbol{\oleft}        {2}{matha}{"68}
\DeclareMathSymbol{\oright}       {2}{matha}{"69}
\DeclareMathSymbol{\otop}         {2}{matha}{"6A}
\DeclareMathSymbol{\obot}         {2}{matha}{"6B}
	\mathabx@aliases\obot\operp
\DeclareMathSymbol{\ovoid}        {2}{matha}{"6C}
\DeclareMathSymbol{\oslash}       {2}{matha}{"6D}
\DeclareMathSymbol{\obackslash}   {2}{matha}{"6E}
\DeclareMathSymbol{\otriangleup}  {2}{matha}{"6F}
\end@mathabx
%
\mathabx@mathb
\mathabx@verbose{\paragraph{Boxes (mathb)}
The following boxed binary operators are just the twins
of the corresponding circled binary operators of {\it matha}.
One can remark that {\tt\string\Box} is defined here (as an
ordinary symbol).}%
%
\DeclareMathSymbol{\boxplus}      {2}{mathb}{"60}
\DeclareMathSymbol{\boxminus}     {2}{mathb}{"61}
	\mathabx@aliases\boxminus\boxeddash
\DeclareMathSymbol{\boxtimes}     {2}{mathb}{"62}
\DeclareMathSymbol{\boxdiv}       {2}{mathb}{"63}
\DeclareMathSymbol{\boxdot}       {2}{mathb}{"64}
\DeclareMathSymbol{\boxcirc}      {2}{mathb}{"65}
	\mathabx@aliases\boxcirc\boxedcirc
\DeclareMathSymbol{\boxasterisk}  {2}{mathb}{"66}
	\mathabx@aliases\boxasterisk\boxedast
\DeclareMathSymbol{\boxcoasterisk}{2}{mathb}{"67}
\DeclareMathSymbol{\boxleft}      {2}{mathb}{"68}
\DeclareMathSymbol{\boxright}     {2}{mathb}{"69}
\DeclareMathSymbol{\boxtop}       {2}{mathb}{"6A}
\DeclareMathSymbol{\boxbot}       {2}{mathb}{"6B}
	\mathabx@aliases\boxbot\boxperp
\DeclareMathSymbol{\boxvoid}      {2}{mathb}{"6C}
\mathabx@undefine{\Box}%
\DeclareMathSymbol{\Box}          {0}{mathb}{"6C}
\DeclareMathSymbol{\boxslash}     {2}{mathb}{"6D}
\DeclareMathSymbol{\boxbackslash} {2}{mathb}{"6E}
\DeclareMathSymbol{\boxtriangleup}{2}{mathb}{"6F}
%
%
\ifx\@latexbug\undefined\else\def\mathbfont{\usefont{U}{mathb}{m}{n}}\fi
\newcount\mayacnter%
\newcount\mayacnta%
\newcount\mayacntb%
\newcount\mayacntc%
\newdimen\mayawidth%
%
\def\mayaexpansion{%
	\mayacntc=\mayacnta\mathbfont
	\ifnum\mayacntc=0 0\else
	\loop\ifnum\mayacntc>5\advance\mayacntc by -5\repeat
	\the\mayacntc\mayacntc=\mayacnta
	\loop\ifnum\mayacntc>5\advance\mayacntc by -5 5\repeat
	\fi}%
\def\mayarecurse{{%
	\mayacnta=\mayacnter \divide\mayacnter by 20
	\ifnum\mayacnter>0\mayarecurse\fi
	\mayacntb=\mayacnter 
	\multiply\mayacntb by-20
	\advance\mayacnta by\mayacntb
	\hbox to\mayawidth{\hss\mayaexpansion\hss}}}%
%
\def\maya#1{%
	\mayacnter=#1
	\setbox0\hbox{\mathbfont 0}%
	\mayawidth=\wd0
	\left\mayaleftdelimiter
	\vcenter{\mayarecurse}
	\right\mayarightdelimiter}%
%
\def\mayadigit#1{%
	\mayacnta=#1\hbox{\mathbfont\mayaexpansion}}%
%
\def\mayadelimiters(#1,#2){%
	\let\mayaleftdelimiter=#1
	\let\mayarightdelimiter=#2}%
%
\mayadelimiters(|,|)%
%
\mathabx@verbose{\paragraph{Mayan numerals}
The presence of Mayan numerals ($\mathbfont 0\ 1\ 2\ 3\ 4\ 5$)
in these series is related only to the history
of the development of them. We wanted to have some special numerals
in these series and Mayan ones where enough exotic to be worth
implementing them. 
$$
\mayadelimiters([,])
\maya{1251}+\maya{2135}=\maya{3386}\neq\mayadigit{0}.
$$
This line has been typesetted with
\smallbreak
{\tt\string\mayadelimiters([,])\par
\string\maya$\{$1251$\}$%
+%
\string\maya$\{$2135$\}$%
=%
\string\maya$\{$3386$\}$%
\string\neq
\string\mayadigit$\{$0$\}$}.
\smallbreak
\noindent
Keeping these characters and the corresponding control sequences
is still an open question.}%
%
\end@mathabx%
%
\mathabx@mathx%
\mathabx@verbose{\paragraph{Large operators (mathx)}}%
%
\mathabx@undefine{\sum}%
\DeclareMathSymbol{\sum}    {1}{mathx}{"B0}
\mathabx@undefine{\prod}%
\DeclareMathSymbol{\prod}   {1}{mathx}{"B1}
\mathabx@undefine{\coprod}%
\DeclareMathSymbol{\coprod} {1}{mathx}{"B2}
\DeclareMathSymbol{\intop}  {1}{mathx}{"B3}
\DeclareMathSymbol{\iintop} {1}{mathx}{"B4}
%\def\iintop{\intop\mkern-6mu\intop}
	\mathabx@aliases\iintop\iint
\DeclareMathSymbol{\iiintop}{1}{mathx}{"B5}
%\def\iiintop{\intop\mkern-6mu\intop\mkern-6mu\intop}
	\mathabx@aliases\iiintop\iiint
\DeclareMathSymbol{\ointop} {1}{mathx}{"B6}
	\mathabx@aliases\ointop\oint
\DeclareMathSymbol{\oiintop}{1}{mathx}{"B7}
	\mathabx@aliases\oiintop\oiint
\def\int{\intop\nolimits}%
% look yourself for \nolimits...
\DeclareMathSymbol{\bigplus}        {1}{mathx}{"90}
\DeclareMathSymbol{\bigtimes}       {1}{mathx}{"91}
\DeclareMathSymbol{\bigcomplementop}{1}{mathx}{"92}%
\def\bigcomplement{\bigcomplementop\nolimits}%
%\DeclareMathSymbol{\bigtruc}        {1}{mathx}{"93}
%\DeclareMathSymbol{\bigcurt}        {1}{mathx}{"94}
\mathabx@undefine{\bigcap}%
\DeclareMathSymbol{\bigcap}         {1}{mathx}{"93}
\mathabx@undefine{\bigcup}%
\DeclareMathSymbol{\bigcup}         {1}{mathx}{"94}
\mathabx@undefine{\biguplus}%
\DeclareMathSymbol{\biguplus}       {1}{mathx}{"95}
\mathabx@undefine{\bigsqcap}%
\DeclareMathSymbol{\bigsqcap}       {1}{mathx}{"96}
\mathabx@undefine{\bigsqcup}%
\DeclareMathSymbol{\bigsqcup}       {1}{mathx}{"97}
\DeclareMathSymbol{\bigsquplus}     {1}{mathx}{"98}
\mathabx@undefine{\bigwedge}%
\DeclareMathSymbol{\bigwedge}       {1}{mathx}{"99}
\mathabx@undefine{\bigvee}%
\DeclareMathSymbol{\bigvee}         {1}{mathx}{"9A}
\DeclareMathSymbol{\bigcurlywedge}  {1}{mathx}{"9B}
\DeclareMathSymbol{\bigcurlyvee}    {1}{mathx}{"9C}
%
\mathabx@verbose{\paragraph{Big circles (mathx)}
Here we find the large versions of circled operators
of {\it matha}.}%
%
\mathabx@undefine{\bigoplus}%
\DeclareMathSymbol{\bigoplus}      {1}{mathx}{"C0}
\DeclareMathSymbol{\bigominus}     {1}{mathx}{"C1}
\mathabx@undefine{\bigotimes}%
\DeclareMathSymbol{\bigotimes}     {1}{mathx}{"C2}
\DeclareMathSymbol{\bigodiv}       {1}{mathx}{"C3}
\mathabx@undefine{\bigodot}%
\DeclareMathSymbol{\bigodot}       {1}{mathx}{"C4}
\DeclareMathSymbol{\bigocirc}      {1}{mathx}{"C5}
\DeclareMathSymbol{\bigoasterisk}  {1}{mathx}{"C6}
\DeclareMathSymbol{\bigocoasterisk}{1}{mathx}{"C7}
\DeclareMathSymbol{\bigoleft}      {1}{mathx}{"C8}
\DeclareMathSymbol{\bigoright}     {1}{mathx}{"C9}
\DeclareMathSymbol{\bigotop}       {1}{mathx}{"CA}
\DeclareMathSymbol{\bigobot}       {1}{mathx}{"CB}
	\mathabx@aliases\bigotop\bigoperp
\DeclareMathSymbol{\bigovoid}      {1}{mathx}{"CC}
\DeclareMathSymbol{\bigoslash}     {1}{mathx}{"CD}
\DeclareMathSymbol{\bigobackslash} {1}{mathx}{"CE}
\DeclareMathSymbol{\bigotriangleup}{1}{mathx}{"CF}
%
\mathabx@verbose{\paragraph{Big boxes (mathx)}
Here we find the large versions of boxed operators
of {\it mathb}.}%
%
\DeclareMathSymbol{\bigboxplus}      {1}{mathx}{"D0}
\DeclareMathSymbol{\bigboxminus}     {1}{mathx}{"D1}
\DeclareMathSymbol{\bigboxtimes}     {1}{mathx}{"D2}
\DeclareMathSymbol{\bigboxdiv}       {1}{mathx}{"D3}
\DeclareMathSymbol{\bigboxdot}       {1}{mathx}{"D4}
\DeclareMathSymbol{\bigboxcirc}      {1}{mathx}{"D5}
\DeclareMathSymbol{\bigboxasterisk}  {1}{mathx}{"D6}
\DeclareMathSymbol{\bigboxcoasterisk}{1}{mathx}{"D7}
\DeclareMathSymbol{\bigboxleft}      {1}{mathx}{"D8}
\DeclareMathSymbol{\bigboxright}     {1}{mathx}{"D9}
\DeclareMathSymbol{\bigboxtop}       {1}{mathx}{"DA}
\DeclareMathSymbol{\bigboxbot}       {1}{mathx}{"DB}
	\mathabx@aliases\bigboxbot\bigboxperp
\DeclareMathSymbol{\bigboxvoid}      {1}{mathx}{"DC}
\DeclareMathSymbol{\bigboxslash}     {1}{mathx}{"DD}
\DeclareMathSymbol{\bigboxbackslash} {1}{mathx}{"DE}
\DeclareMathSymbol{\bigboxtriangleup}{1}{mathx}{"DF}
\end@mathabx
%
\mathabx@matha
\mathabx@mathx
\mathabx@verbose{\paragraph{Delimiters (matha/mathx)}
The following delimiters have their smaller form in {\it matha}
and larger ones in {\it mathx}.}%
%
\DeclareMathDelimiter{(}              {matha}{"70}{mathx}{"00}
\DeclareMathDelimiter{)}              {matha}{"71}{mathx}{"08}
\DeclareMathDelimiter{[}              {matha}{"72}{mathx}{"10}
\DeclareMathDelimiter{]}              {matha}{"73}{mathx}{"18}
\DeclareMathDelimiter{\lbrace}     {4}{matha}{"74}{mathx}{"20}
\ifx\@latexbug\undefined
	\mathabx@aliases\lbrace\{
\else% suggested by Patrick Cousot
	\DeclareRobustCommand{\{}{\ifmmode\lbrace\else\textbraceleft\fi}
\fi
\DeclareMathDelimiter{\rbrace}     {5}{matha}{"75}{mathx}{"28}
\ifx\@latexbug\undefined
	\mathabx@aliases\rbrace\}
\else
	\DeclareRobustCommand{\}}{\ifmmode\rbrace\else\textbraceright\fi}
\fi
\DeclareMathDelimiter{\ldbrack}   {4}{matha}{"76}{mathx}{"30}
	\mathabx@aliases\ldbrack\lsemantic
\DeclareMathDelimiter{\rdbrack}   {5}{matha}{"77}{mathx}{"38}
	\mathabx@aliases\rdbrack\rsemantic
\DeclareMathDelimiter{\langle}     {4}{matha}{"78}{mathx}{"40}
\DeclareMathDelimiter{\rangle}     {5}{matha}{"79}{mathx}{"44}
\mathabx@undefine{\backslash}%
\DeclareMathDelimiter{\backslash}  {0}{matha}{"7A}{mathx}{"48}
\DeclareMathDelimiter{/}              {matha}{"7B}{mathx}{"4C}
\DeclareMathDelimiter{\vert}       {0}{matha}{"7C}{mathx}{"07}
\DeclareMathDelimiter{|}              {matha}{"7C}{mathx}{"07}
\DeclareMathDelimiter{\Vert}       {0}{matha}{"7D}{mathx}{"0F}
\mathabx@undefine{\|}%
	\mathabx@aliases\Vert\|
\DeclareMathDelimiter{\vvvert}     {0}{matha}{"7E}{mathx}{"17}
\DeclareMathDelimiter{\uparrow}    {3}{matha}{"D2}{mathx}{"9D}
\DeclareMathDelimiter{\downarrow}  {3}{matha}{"D3}{mathx}{"9E}
\DeclareMathDelimiter{\updownarrow}{3}{matha}{"D9}{mathx}{"9F}
\DeclareMathDelimiter{\Uparrow}    {3}{matha}{"F2}{mathx}{"AD}
\DeclareMathDelimiter{\Downarrow}  {3}{matha}{"F3}{mathx}{"AE}
\DeclareMathDelimiter{\Updownarrow}{3}{matha}{"F5}{mathx}{"AF}
\end@mathabx
\end@mathabx
\mathabx@mathb
\mathabx@mathx
\mathabx@verbose{\paragraph{Delimiters (mathb/mathx)}}%
%
\DeclareMathDelimiter{\lgroup}     {4}{mathb}{"70}{mathx}{"76}% fully supp.
\DeclareMathDelimiter{\rgroup}     {5}{mathb}{"71}{mathx}{"77}% fully supp.
\DeclareMathDelimiter{\lceil}      {4}{mathb}{"72}{mathx}{"50}
\DeclareMathDelimiter{\rceil}      {5}{mathb}{"73}{mathx}{"54}
\DeclareMathDelimiter{\lfloor}     {4}{mathb}{"74}{mathx}{"58}
\DeclareMathDelimiter{\rfloor}     {5}{mathb}{"75}{mathx}{"5C}
\DeclareMathDelimiter{\thickvert}  {0}{mathb}{"7E}{mathx}{"1F}
\end@mathabx
\end@mathabx
%
\mathabx@mathx
\mathabx@verbose{\paragraph{Delimiters (mathx/mathx)}}%
%
\DeclareMathDelimiter{\lfilet}     {4}{mathx}{"37}{mathx}{"37}
\DeclareMathDelimiter{\rfilet}     {5}{mathx}{"3F}{mathx}{"3F}
%
\DeclareMathDelimiter{\lmoustache}{4}{mathx}{"05}{mathx}{"05}% not supp.
\DeclareMathDelimiter{\rmoustache}{5}{mathx}{"0D}{mathx}{"0D}% not supp.
\end@mathabx
%
\mathabx@mathx
\mathabx@verbose{\paragraph{Pieces for over-under-braces and such (mathx)}
{\it Mathx}\/ series provide the following bricks:}%
%
\DeclareMathSymbol{\braceld}       {0}{mathx}{"68}
\DeclareMathSymbol{\bracemd}       {0}{mathx}{"69}
\DeclareMathSymbol{\bracerd}       {0}{mathx}{"6A}
\DeclareMathSymbol{\bracexd}       {0}{mathx}{"6B}
\DeclareMathSymbol{\bracelu}       {0}{mathx}{"6C}
\DeclareMathSymbol{\bracemu}       {0}{mathx}{"6D}
\DeclareMathSymbol{\braceru}       {0}{mathx}{"6E}
\DeclareMathSymbol{\bracexu}       {0}{mathx}{"6F}
%
% Borrowed from "newmath" by Matthias Clasen and Ulrik Vieth.
%
\def\braceexwd{2mu}%
\def\bracevkern{0pt}%
%
% Remark: it seems that new horizontal braces may take
% into account vertical skip in their native design.
% We've followed this idea and not Knuth's construction.
% But we can add or sustract \bracevkern.
%
\def\bracefill#1#2#3#4{$\m@th
	#1#4\mkern-\braceexwd \cleaders\hbox{$#4$}\hfill
	\mkern-\braceexwd#4#2#4\mkern-\braceexwd
	\cleaders\hbox{$#4$}\hfill \mkern-\braceexwd#4#3$}%
%
\def\overbrace@#1#2{\mathop{\vbox{\m@th\ialign{##\crcr
	\noalign{\kern\bracevkern}
	#1\crcr\noalign{\kern\bracevkern\nointerlineskip}%
	$\hfil\displaystyle{#2}\hfil$\crcr}}}\limits}%
%
\def\underbrace@#1#2{\mathop{\vtop{\m@th\ialign{##\crcr
	$\hfil\displaystyle{#2}\hfil$\crcr
	\noalign{\kern\bracevkern\nointerlineskip}
	#1\crcr\noalign{\kern\bracevkern}}}}\limits}%
% user-level macros
\def\overbrace{\overbrace@{\bracefill\braceld\bracemd\bracerd\bracexd}}
\def\underbrace{\underbrace@{\bracefill\bracelu\bracemu\braceru\bracexu}}
\def\overgroup{\overbrace@{\bracefill\braceld{}\bracerd\bracexd}}
\def\undergroup{\underbrace@{\bracefill\bracelu{}\braceru\bracexu}}
%
\mathabx@verbose{\noindent The control sequences {\tt\string\overbrace}, etc.,
have been defined as suggested by Matthias Clasen and Ulrik Vieth
in {\it newmath}. For instance:
$$
\displaylines{
\overbrace{abcde}\quad(\hbox{\tt\string\overbrace$\{$abcde$\}$}),\qquad
\underbrace{abcde}\quad(\hbox{\tt\string\underbrace$\{$abcde$\}$}),
\cr
\overgroup{abcde}\quad(\hbox{\tt\string\overgroup$\{$abcde$\}$}),\qquad
\undergroup{abcde}\quad(\hbox{\tt\string\undergroup$\{$abcde$\}$}).}$$}%
%
\mathabx@verbose{\paragraph{Extensible accents (mathx)}}%
%
\DeclareMathAccent{\widehat}      {0}{mathx}{"70}
\DeclareMathAccent{\widecheck}    {0}{mathx}{"71}
\DeclareMathAccent{\widetilde}    {0}{mathx}{"72}
\DeclareMathAccent{\widebar}      {0}{mathx}{"73}
\DeclareMathAccent{\widearrow}    {0}{mathx}{"74}
\DeclareMathAccent{\wideparen}    {0}{mathx}{"75}
	\def\widering#1{\ring{\wideparen{#1}}}%
	\def\widedot#1{\dot{\wideparen{#1}}}%
	\def\wideddot#1{\ddot{\wideparen{#1}}}%
	\def\widedddot#1{\dddot{\wideparen{#1}}}%
	\def\wideddddot#1{\ddddot{\wideparen{#1}}}%
\edef\surd{{\noexpand\mathchar"1\expandafter\hexnumber@
	\ifx\@latexbug\undefined\mathxfam\else\symmathx\fi60}}%
\ifx\@latexbug\undefined
	\ifx\mathabx@matha\relax
		\DeclareMathRadical{\sqrt}{matha}{"3F}{mathx}{"61}
	\else
		\DeclareMathRadical{\sqrt}{mathx}{"60}{mathx}{"61}
	\fi
\else% suggested by Kohsaku Hotta
	\mathabx@undefine{\sqrtsign}%
	\ifx\mathabx@matha\relax
		\DeclareMathRadical{\sqrtsign}{matha}{"3F}{mathx}{"61}
	\else
		\DeclareMathRadical{\sqrtsign}{mathx}{"60}{mathx}{"61}
	\fi
\fi
\end@mathabx
%
\mathabx@extra
\def\@anyfill#1#2#3#4{$\m@th#4
	\ifx#1\relax\relax\smash#2\mkern-7mu\else\mathord#1\mkern-7mu\fi
	\cleaders\hbox{$#4\mkern-2mu\smash#2\mkern-2mu$}\hfill
	\ifx#3\relax\relax\mkern-7mu\smash#2\else\mkern-7mu\mathord#3\fi$}

\def\@overfill#1#2#3#4#5#6{
	\vbox{\m@th\ialign{##\crcr
	\@anyfill{#2}{#3}{#4}#5\crcr
	\noalign{\kern#1\nointerlineskip}%
	$\hfil#5{#6}\hfil$\crcr}}}%

\def\@underfill#1#2#3#4#5#6{
	\vtop{\m@th\ialign{##\crcr
	$\hfil#5{#6}\hfil$\crcr
	\noalign{\kern#1\nointerlineskip}%
	\@anyfill{#2}{#3}{#4}#5\crcr}}}%

\def\overfill#1#2{\mathpalette{\@overfill#1}{#2}}
\def\underfill#1#2{\mathpalette{\@underfill#1}{#2}}

\def\overrightarrow{\overfill{{-.25ex}{}\relbar\rightarrow}}%
\def\overleftarrow{\overfill{{-.25ex}\leftarrow\relbar{}}}%
\def\overleftrightarrow{\overfill{{-.25ex}\leftarrow\relbar\rightarrow}}%
\def\underrightarrow{\underfill{{.25ex}{}\relbar\rightarrow}}%
\def\underleftarrow{\underfill{{.25ex}\leftarrow\relbar{}}}%
\def\underleftrightarrow{\underfill{{.25ex}\leftarrow\relbar\rightarrow}}%
\def\overRightarrow{\overfill{{-.05ex}{}\Relbar\Rightarrow}}%
\def\overLeftarrow{\overfill{{-.05ex}\Leftarrow\Relbar{}}}%
\def\overLeftRightarrow{\overfill{{-.05ex}\Leftarrow\Relbar\Rightarrow}}%
\def\underRightarrow{\underfill{{.25ex}{}\Relbar\Rightarrow}}%
\def\underLeftarrow{\underfill{{.25ex}\Leftarrow\Relbar{}}}%
\def\underLeftRightarrow{\underfill{{.25ex}\Leftarrow\Relbar\Rightarrow}}%

%\def\sumint{\mathpalette\@sumint{}}
%\def\@sumint#1#2{\mathop{\setbox0=\hbox{$#1\sum$}%
%	\hbox to 0pt{\hbox to\wd0{\hss$\displaystyle\int$\hss}\hss}\box0}\limits}%
\end@mathabx
%
% UNSUPPORTED!!!
%
\mathabx@unsupported
\def\mathabx@list#1#2#3{\edef\tmp{\the\count254}\count254=#3%
	\def\mathabx@next##1{\ifx\end##1%
		\let\mathabx@next=\relax
		\count254=\tmp
	\else
		\DeclareMathSymbol{##1}{#1}{#2}{\the\count254}%
		\advance\count254 by 1\fi
	\mathabx@next}%
	\mathabx@next}%
%
\mathabx@verbose{\paragraph{Unsupported stuff (mathum10 and mathub10)}
First something under construction}
\DeclareMathSymbol{\strictif}         {3}{mathu}{"0D}
\DeclareMathSymbol{\strictfi}         {3}{mathu}{"0E}
\DeclareMathSymbol{\strictiff}        {3}{mathu}{"0F}
\mathabx@verbose{%
$$
A\strictif B\strictfi C,\qquad E\strictiff F.
$$
First some geometrical shapes (names are not to be taken too seriously):}%
%
\mathabx@list{0}{mathu}{"00}
\geometricsquare\geometricpentagon\geometrichexagon\geometricoctogon\vargeometricsquare\vargeometricpentagon\vargeometrichexagon\vargeometricoctogon\geometricstar\geometricblackstar\vargeometricstar\vargeometricblackstar
\end
%
\mathabx@verbose{\noindent Then, triangles again (names are not to be taken too seriously):}%
\mathabx@list{2}{mathu}{"10}
\mediumtriangleup\mediumtriangledown\mediumtriangleleft\mediumtriangleright\mediumblacktriangleup\mediumblacktriangledown\mediumblacktriangleleft\mediumblacktriangleright
\largetriangleup\largetriangledown\largetriangleleft\largetriangleright\largeblacktriangleup\largeblacktriangledown\largeblacktriangleleft\largeblacktriangleright
\end
%
\mathabx@verbose{\noindent Others (names are not to be taken too seriously).
Among the many remarks I can do about the following symbols: ``Q''
things may originate from the S$^{\rm t}$ Mary Road font, but I can't
remember why it has been extended to four symbols; dotted intersection
and union signs have became classical; arrowed cup sign can be found
in Unicode; a bold complement sign is closer to sixties french uses;
bold intersection and union come from I don't know where; small
versions of ``smile'' and ``frown'' come from AMS choices (\dots), it
is certainly the same for the next symbols up to the asterisks; these
asterisks are not useful; Bourbaki's Z is self explainatory; the
maltese cross comes from AMS and I choosed to design it with
arithmetical bounds; the nuclear sign for my own distraction; I've
made some attempts in drawing anew cards suits (heart, diamond, spade,
club [to be revised!]
and joker [a more or less classical version and a design coming
from Grimaud cards]) and dices (from 1 to 6 in two versions); the
greek motive comes from the embellishment of my favorite pen; the
ghanean motive from some commercial font (ITC Kokoa? I am not sure of
that) based on traditional african motives, and thus may (should) be
free of rights. The two last motives have been designed as fleurons in
order to decorate my lecture notes.}%
\mathabx@list{0}{mathu}{"20}\nwQ\neQ\swQ\seQ\end
\mathabx@list{2}{mathu}{"24}\capdot\cupdot\sqcapdot\sqcupdot\cuparrow\end
\mathabx@list{1}{mathu}{"29}\boldcomplement\end
\mathabx@list{2}{mathu}{"2A}\boldcap\boldcup\smallsmile\smallfrown\end
\mathabx@list{0}{mathu}{"2E}\backprime\reverseneg\end
\mathabx@list{2}{mathu}{"30}\smashprod\end
\mathabx@list{3}{mathu}{"31}\simsimbar\notsimsimbar\barsim\notbarsim\simvert\revsim\revsimbar\end
\mathabx@undefine{\maltese}%
\mathabx@list{0}{mathu}{"38}\upperasterisk\lowerasterisk\tripleasterisks\BourbakiZ\maltese\varmaltese\maltesegeometric\nuclear\heartsuit\diamondsuit\spadesuit\clubsuit\jokersuit\varjokersuit\end

\mathabx@list{0}{mathu}{"6E}\greekmotive\ghaneanmotive
\end
\def\dice#1{{\count@=\mathufam\multiply\count@ by 256
	\advance\count@ by "45\advance\count@ by #1\mathchar\count@}}%
\def\Dice#1{{\count@=\mathufam\multiply\count@ by 256
	\advance\count@ by "4B\advance\count@ by #1\mathchar\count@}}%
\def\domino#1#2{{\count@=\mathufam\multiply\count@ by 256
	\advance\count@ by "52\advance\count@ by #1
	\ifx#2r\advance\count@ by 7\else
		\ifx#2u\advance\count@ by 14\else
			\ifx#2d\advance\count@ by 21\fi\fi\fi
	\mathchar\count@}}
\mathabx@verbose{\noindent I don't really like games of chance but it is funny to typeset
$$
	\dice4\quad\dice2\quad\dice1
	\qquad\hbox{or}\qquad
	\Dice4\quad\Dice2\quad\Dice1
$$
Control sequences {\tt\string\dice} (left sample)
and {\tt\string\Dice} (right sample) have only
one argument which should be a numeral in $\{1,2,3,4,5,6\}$
($\dice1\dice2\dice3\dice4\dice5\dice6$,
$\Dice1\Dice2\Dice3\Dice4\Dice5\Dice6$).  About dominos, there is a
control sequence named {\tt\string\domino} with two arguments. The
first argument is a numeral in $\{0,1,2,3,4,5,6\}$, the second one is a
single letter in $\{$ l, r u, d$\}$ (left, right, up, down). For
example:
$$
	\vbox{\offinterlineskip
	\def\dominoskip#1{{\setbox0=\hbox{$\domino0l\domino0r$}%
		\hskip#1\wd0}}%
	\hbox{$\domino0l\domino1r
	\domino1l\domino2r
	\domino2l\domino3r
	\domino3l\domino4r$}%
	\hbox{$\domino0u\dominoskip3\domino4u$}%
	\hbox{$\domino1d\dominoskip3\domino5d$}%
	\hbox{$\domino1u\dominoskip3\domino5u$}%
	\hbox{$\domino2d\dominoskip3\domino6d$}%
	\hbox{$\domino2u\dominoskip3\domino6u$}%
	\hbox{$\domino3d\dominoskip3\domino0d$}%
	\hbox{$\domino3l\domino2r\domino2l\domino1r
	\domino1l\domino0r\domino0l\domino0r$}%
}
$$}
\mathabx@verbose{\noindent Some arrows (double vertical arrows should be defined as extensible symbols):}
\mathabx@list{3}{mathu}{"B0}\nuparrow\ndownarrow \nupdownarrow
  \nUparrow\nDownarrow \nUpdownarrow
  \lefttriplearrow\righttriplearrow\leftrighttriplearrow
\end
\mathabx@verbose{\noindent Triple horizontal arrows can be extended with {\tt\string\equiv} and {\tt\string\joinrel}  $A\equiv\joinrel\righttriplearrow B$,
and thus, negated too $A\equiv\joinrel\notequiv\joinrel\righttriplearrow B$.
But this is not really fine (too large length).}
%
\mathabx@verbose{\noindent Other circled operators (names are not to be taken too seriously):}%
\mathabx@list{2}{mathu}{"C0}
\otruc\ocurt\obullet\ostar\ovarstar\otriangledown\otriangleleft\otriangleright\odotminus\ominusdot\ohoriz\overt\ocross\oacross\oless\ogreater\owedge\ovee\oblackleft\oblackright\oblackup\oblackdown\oblackul\oblackur\oblackll\oblacklr\oyingyang\oradioactive\opeacelove\oequal
\end
%
\mathabx@verbose{\noindent And the corresponding boxed operators (names are not to be taken too seriously):}%
\mathabx@list{2}{mathu}{"E0}
\boxtruc\boxcurt\boxbullet\boxstar\boxvarstar\boxtriangledown\boxtriangleleft\boxtriangleright\boxdotminus\boxminusdot\boxbar\boxvert\boxcross\boxacross\boxless\boxgreater\boxwedge\boxvee\boxblackleft\boxblackright\boxblackup\boxblackdown\boxblackul\boxblackur\boxblackll\boxblacklr\boxyingyang\boxradioactive\boxpeacelove\boxequal
\end
%
\mathabx@verbose{\paragraph{Unsupported stuff (mathuxm10 and mathuxb10)}
The following symbols are rather unusual for me, but they may appear elsewhere (names are not to be taken too seriously):}%
\mathabx@list{1}{mathux}{"00}
\bigcapdot\bigcupdot\bigsqcapdot\bigsqcupdot\bigcuparrow\bigtop\bigbot\bigZ\bigtriangleup\bigtriangledown
\end
\mathabx@list{1}{mathux}{"20}
\oiiintop\ointctrclockwiseop\ointclockwiseop\intclockwiseop\sqintop\sqintctrclockwiseop\sqintclockwiseop
\end
%
\mathabx@verbose{\noindent Other large circled operators (names are not to be taken too seriously):}%
\mathabx@list{1}{mathux}{"80}
\bigotruc\bigocurt\bigobullet\bigostar\bigovarstar\bigotriangledown\bigotriangleleft\bigotriangleright\bigodotminus\bigominusdot\bigohoriz\bigovert\bigocross\bigoacross\bigoless\bigogreater\bigowedge\bigovee\bigoblackleft\bigoblackright\bigoblackup\bigoblackdown\bigoblackul\bigoblackur\bigoblackll\bigoblacklr\bigoyingyang\bigoradioactive\bigopeacelove\bigoequal
\end
%
\mathabx@verbose{\noindent And the corresponding large boxed operators (names are not to be taken too seriously):}%
\mathabx@list{1}{mathux}{"A0}
\bigboxtruc\bigboxcurt\bigboxbullet\bigboxstar\bigboxvarstar\bigboxtriangledown\bigboxtriangleleft\bigboxtriangleright\bigboxdotminus\bigboxminusdot\bigboxhoriz\bigboxvert\bigboxcross\bigboxacross\bigboxless\bigboxgreater\bigboxwedge\bigboxvee\bigboxblackleft\bigboxblackright\bigboxblackup\bigboxblackdown\bigboxblackul\bigboxblackur\bigboxblackll\bigboxblacklr\bigboxyingyang\bigboxradioactive\bigboxpeacelove\bigboxequal
\end
\end@mathabx
%
%\mathabx@verbose{\centerline{---~Leaving {\tt mathabx.dcl}~---}}
%
\catcode`@=12
\endinput
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% UNAVAILABLE
%
%\mathabx@verbose{\paragraph{Small things ???}
%
\DeclareMathSymbol{\boldcomplement}{0}{mathx}{"44}
\DeclareMathSymbol{\boldcup}{2}{mathx}{"45}
\DeclareMathSymbol{\boldcap}{2}{mathx}{"46}
\DeclareMathSymbol{\boldZ}{0}{mathx}{"47}
\DeclareMathSymbol{\bigboldZ}{1}{mathx}{"4A}
%
%\mathabx@verbose{\paragraph{Inequalities (mathbb) unsupported}
%
%\DeclareMathSymbol{\preceqq}{3}{mathb}{"AE}
%\DeclareMathSymbol{\succeqq}{3}{mathb}{"AF}
%\DeclareMathSymbol{\notpreceqq}{3}{mathb}{"B0}
%	\let\@notpreceqq=!
%	\let\npreceqq=\notpreceqq
%\DeclareMathSymbol{\notsucceqq}{3}{mathb}{"B1}
%	\let\@notqeqq=!
%	\let\nsucceqq=\notsucceqq
%\DeclareMathSymbol{\precneqq}{3}{mathb}{"B2}
%\DeclareMathSymbol{\succneqq}{3}{mathb}{"B3}
%\DeclareMathSymbol{\precvertneqq}{3}{mathb}{"B4}
%\DeclareMathSymbol{\succvertneqq}{3}{mathb}{"B5}
%\DeclareMathSymbol{\precsucc}{3}{mathb}{"B2}
%\DeclareMathSymbol{\succprec}{3}{mathb}{"B3}
%\DeclareMathSymbol{\preceqsucc}{3}{mathb}{"B4}
%\DeclareMathSymbol{\succeqprec}{3}{mathb}{"B5}
%\DeclareMathSymbol{\preceqqsucc}{3}{mathb}{"B6}
%\DeclareMathSymbol{\succeqqprec}{3}{mathb}{"B7}

%\DeclareMathSymbol{\upasterisk}{0}{matha}{}
%\DeclareMathSymbol{\lowasterisk}{0}{matha}{}
%\DeclareMathSymbol{\triasterisk}{0}{matha}{}
%
\mathabx@verbose{\paragraph{Hebrew (matha/mathb)}}%
%
\DeclareMathSymbol{\aleph}{7}{matha}{"40}
\DeclareMathSymbol{\beth}{7}{matha}{"41}
\DeclareMathSymbol{\gimmel}{7}{matha}{"42}
\DeclareMathSymbol{\dalet}{7}{matha}{"43}
\DeclareMathSymbol{\he}{7}{matha}{"44}
\DeclareMathSymbol{\vav}{7}{matha}{"45}
\DeclareMathSymbol{\zayin}{7}{matha}{"46}
\DeclareMathSymbol{\het}{7}{matha}{"47}
\DeclareMathSymbol{\tet}{7}{matha}{"48}
\DeclareMathSymbol{\yod}{7}{matha}{"49}
\DeclareMathSymbol{\finalkaf}{7}{matha}{"4A}
\DeclareMathSymbol{\kaf}{7}{matha}{"4B}
\DeclareMathSymbol{\lamed}{7}{matha}{"4C}
\DeclareMathSymbol{\finalmem}{7}{matha}{"4D}
\DeclareMathSymbol{\mem}{7}{matha}{"4E}
\DeclareMathSymbol{\finalnun}{7}{matha}{"4F}
\DeclareMathSymbol{\nun}{7}{matha}{"50}
\DeclareMathSymbol{\samekh}{7}{matha}{"51}
\DeclareMathSymbol{\ayin}{7}{matha}{"52}
\DeclareMathSymbol{\finalpe}{7}{matha}{"53}
\DeclareMathSymbol{\pe}{7}{matha}{"54}
\DeclareMathSymbol{\finaltzadik}{7}{matha}{"55}
\DeclareMathSymbol{\tzadik}{7}{matha}{"56}
\DeclareMathSymbol{\qof}{7}{matha}{"57}
\DeclareMathSymbol{\resh}{7}{matha}{"58}
\DeclareMathSymbol{\shin}{7}{matha}{"59}
\DeclareMathSymbol{\tav}{7}{matha}{"5A}
%
% \DeclareMathSymbol{\Qinv}        {0}{matha}{"4A}
% \DeclareMathSymbol{\BourbarkiZ}  {0}{matha}{"4F}
%%%{\catcode`\=\active \gdef{^\degree}}
%%%\mathcode`\="8000
%%% pas bon du tout, il faudrait pouvoir
%%% le melanger avec les '''
%
%
%\DeclareMathSymbol{\dottruc}       {2}{mathb}{"06}% name to be checked
%\DeclareMathSymbol{\dotcurt}       {2}{mathb}{"07}% name to be checked
\DeclareMathSymbol{\truc}          {2}{matha}{"06}
\DeclareMathSymbol{\curt}          {2}{matha}{"07}
